<?php

require_once(dirname(__FILE__) .'/../../config.php');
require_once("lib.php");
require_once("locallib.php");
require_once($CFG->libdir . '/completionlib.php');
require_once("config.php");

$id         = required_param('id', PARAM_INT);                 // Course Module ID
$action     = optional_param('action', '', PARAM_ALPHANUMEXT);
$attemptids = optional_param_array('attemptid', array(), PARAM_INT); // Get array of responses to delete or modify.
$userids    = optional_param_array('userid', array(), PARAM_INT); // Get array of users whose choices need to be modified.
$notify     = optional_param('notify', '', PARAM_ALPHA);
$upload_pressed = optional_param('upload_pressed', 0, PARAM_INT);
$view_pdf = optional_param('view_pdf', 0, PARAM_INT);
$sign_pdf = optional_param('sign_pdf', 0, PARAM_INT);

$url = new moodle_url('/mod/signactivityserver/view.php', array('id'=>$id));
if ($action !== '') {
    $url->param('action', $action);
}
$PAGE->set_url($url);

if (! $cm = get_coursemodule_from_id('signactivityserver', $id)) {
    print_error('invalidcoursemodule');
}

if (! $course = $DB->get_record("course", array("id" => $cm->course))) {
    print_error('coursemisconf');
}

require_course_login($course, false, $cm);

if (!$choice = signactivityserver_get_choice($cm->instance)) {
    print_error('invalidcoursemodule');
}

$strchoice = get_string('modulename', 'signactivityserver');
$strchoices = get_string('modulenameplural', 'signactivityserver');

$context = context_module::instance($cm->id);

list($choiceavailable, $warnings) = signactivityserver_get_availability_status($choice);

if ($action == 'delchoice' and confirm_sesskey() and is_enrolled($context, NULL, 'mod/signactivityserver:choose') and $choice->allowupdate
        and $choiceavailable) {
    $answercount = $DB->count_records('sig_choice_answers', array('choiceid' => $choice->id, 'userid' => $USER->id));
    if ($answercount > 0) {
        $choiceanswers = $DB->get_records('sig_choice_answers', array('choiceid' => $choice->id, 'userid' => $USER->id),
            '', 'id');
        $todelete = array_keys($choiceanswers);
        signactivityserver_delete_responses($todelete, $choice, $cm, $course);
        redirect("view.php?id=$cm->id");
    }
}

$PAGE->set_title($choice->name);
$PAGE->set_heading($course->fullname);

/// Submit any new data if there is any
if (data_submitted() && !empty($action) && confirm_sesskey()) {
    $timenow = time();
    if (has_capability('mod/signactivityserver:deleteresponses', $context)) {
        if ($action === 'delete') {
            // Some responses need to be deleted.
            signactivityserver_delete_responses($attemptids, $choice, $cm, $course);
            redirect("view.php?id=$cm->id");
        }
        if (preg_match('/^choose_(\d+)$/', $action, $actionmatch)) {
            // Modify responses of other users.
            $newoptionid = (int)$actionmatch[1];
            signactivityserver_modify_responses($userids, $attemptids, $newoptionid, $choice, $cm, $course);
            redirect("view.php?id=$cm->id");
        }
    }

    // Redirection after all POSTs breaks block editing, we need to be more specific!
    if ($choice->allowmultiple) {
        $answer = optional_param_array('answer', array(), PARAM_INT);
    } else {
        $answer = optional_param('answer', '', PARAM_INT);
    }
    
    if (!$choiceavailable) {
        $reason = current(array_keys($warnings));
        throw new moodle_exception($reason, 'choice', '', $warnings[$reason]);
    }

    if ($answer && is_enrolled($context, null, 'mod/signactivityserver:choose')) {
        signactivityserver_user_submit_response($answer, $choice, $USER->id, $course, $cm);
        redirect(new moodle_url('/mod/signactivityserver/view.php',
            array('id' => $cm->id, 'notify' => 'choicesaved', 'sesskey' => sesskey())));
    } else if (empty($answer) and $action === 'makechoice') {
        // We cannot use the 'makechoice' alone because there might be some legacy renderers without it,
        // outdated renderers will not get the 'mustchoose' message - bad luck.
        redirect(new moodle_url('/mod/signactivityserver/view.php',
            array('id' => $cm->id, 'notify' => 'mustchooseone', 'sesskey' => sesskey())));
    }
}

// Completion and trigger events.
signactivityserver_view($choice, $course, $cm, $context);

echo $OUTPUT->header();
echo $OUTPUT->heading(format_string($choice->name), 2, null);

if ($notify and confirm_sesskey()) {
    if ($notify === 'choicesaved') {
        echo $OUTPUT->notification(get_string('choicesaved', 'choice'), 'notifysuccess');
    } else if ($notify === 'mustchooseone') {
        echo $OUTPUT->notification(get_string('mustchooseone', 'choice'), 'notifyproblem');
    }
}

/// Display the choice and possibly results
$eventdata = array();
$eventdata['objectid'] = $choice->id;
$eventdata['context'] = $context;

/// Check to see if groups are being used in this choice
$groupmode = groups_get_activity_groupmode($cm);

if ($groupmode) {
    groups_get_activity_group($cm, true);
    groups_print_activity_menu($cm, $CFG->wwwroot . '/mod/signactivityserver/view.php?id='.$id);
}

// Check if we want to include responses from inactive users.
$onlyactive = $choice->includeinactive ? false : true;

$allresponses = signactivityserver_get_response_data($choice, $cm, $groupmode, $onlyactive);   // Big function, approx 6 SQL calls per user.


if (has_capability('mod/signactivityserver:readresponses', $context)) {
    signactivityserver_show_reportlink($allresponses, $cm);
}

echo '<div class="clearer"></div>';

if ($choice->intro) {
    echo $OUTPUT->box(format_module_intro('signactivityserver', $choice, $cm->id), 'generalbox', 'intro');
}

$timenow = time();
$current = signactivityserver_get_my_response($choice);
$answered = empty($current) ? false : signactivityserver_check_answered($choice, reset($current)->optionid);

//if user has already made a selection, and they are not allowed to update it or if choice is not open, show their selected answer.
if (isloggedin() && (!empty($current)) && 
    (empty($choice->allowupdate) || ($timenow > $choice->timeclose)) ) {
    $answer = $DB->get_record('sig_choice_answers', array('choiceid' => $choice->id, 'userid' => $USER->id));    
    $option = $DB->get_record('sig_choice_options', array('id' => $answer->optionid));

    if ($option && $option->signable) {
        //get file
        $fs = get_file_storage();
        $file = $fs->get_file_by_hash($answer->pathnamehash);

        $url = moodle_url::make_pluginfile_url($file->get_contextid(), $file->get_component(), $file->get_filearea(), $file->get_itemid(), $file->get_filepath(), $file->get_filename(), false);

        //html
        $linkDownloadDoc = '<a href="'.$url.'" target="_blank">';
            $linkDownloadDoc .= get_string('view_PDF', 'mod_signactivityserver').'<i class="fa fa-file-pdf-o" style="margin-left:10px;" aria-hidden="true"></i>';
        $linkDownloadDoc .= '</a>';

        echo $OUTPUT->box($linkDownloadDoc, 'm-b-1');
    }
        
    $choicetexts = array();
    foreach ($current as $c) {
        $choicetexts[] = format_string(signactivityserver_get_option_text($choice, $c->optionid));
    }

    echo $OUTPUT->box(get_string("yourselection", "choice", userdate($choice->timeopen)).": ".implode('; ', $choicetexts), 'generalbox', 'yourselection');
}

$content = '';
$context = context_module::instance($cm->id);
$filehash = $DB->get_record_select('files', 'contextid = '.$context->id.' AND filearea = "document_to_sign" AND filesize <> 0', null, 'userid, pathnamehash');
if ($filehash) {
    $fs = get_file_storage();
    $file = $fs->get_file_by_hash($filehash->pathnamehash);
    $content = $file->get_content();
}

/// Print the form
$choiceopen = true;
if ((!empty($choice->timeopen)) && ($choice->timeopen > $timenow)) {
    if ($choice->showpreview) {
        echo $OUTPUT->box(get_string('previewonly', 'choice', userdate($choice->timeopen)), 'generalbox alert');
    } else {
        echo $OUTPUT->box(get_string("notopenyet", "choice", userdate($choice->timeopen)), "generalbox notopenyet");
        echo $OUTPUT->footer();
        exit;
    }
} else if ((!empty($choice->timeclose)) && ($timenow > $choice->timeclose)) {
    echo $OUTPUT->box(get_string("expired", "choice", userdate($choice->timeclose)), "generalbox expired");
    $choiceopen = false;
} else if (has_capability('mod/signactivityserver:addinstance', $context)) {
    
    echo $OUTPUT->box_start('generalbox', 'notice');
    echo $OUTPUT->container_start('continuebutton');
    if(!$upload_pressed) {
        if (!$content) echo '<p align="center">'. get_string('nopdf', 'mod_signactivityserver') .'</p>';
        echo $OUTPUT->single_button(new moodle_url($PAGE->url, array(
            'upload_pressed' => 1,
        )), $content ? get_string('edit_pdf', 'mod_signactivityserver') : get_string('upload_pdf', 'mod_signactivityserver'), 'get');
    }
    else {
        $key = random_string(10) . '_' . $USER->id;
        save_key($key);
        $params = ['key' => $key];

        echo get_signature_iframe('edit_embed', $cm->instance, $content, $key, $params);
    }
    echo $OUTPUT->container_end();
    echo $OUTPUT->box_end();
       
    $choiceopen = false;
}
else if(is_enrolled($context, NULL, 'mod/signactivityserver:choose') && $view_pdf) {
    echo $OUTPUT->box_start('generalbox', 'notice');
    echo $OUTPUT->container_start('continuebutton');
    echo get_signature_iframe('view_embed', $cm->instance, $content);
    echo $OUTPUT->container_end();
    echo $OUTPUT->box_end();
}
else if (!$content) {
    echo $OUTPUT->box(get_string("not_available", "mod_signactivityserver"));
    $choiceopen = false;
}

if ( !$view_pdf && (!$answered || $choice->allowupdate) && $choiceopen && is_enrolled($context, NULL, 'mod/signactivityserver:choose')) {

    // Show information on how the results will be published to students.
    $publishinfo = null;
    switch ($choice->showresults) {
        case SIG_SHOWRESULTS_NOT:
            $publishinfo = get_string('publishinfonever', 'choice');
            break;

        case SIG_SHOWRESULTS_AFTER_ANSWER:
            if ($choice->publish == SIG_PUBLISH_ANONYMOUS) {
                $publishinfo = get_string('publishinfoanonafter', 'choice');
            } else {
                $publishinfo = get_string('publishinfofullafter', 'choice');
            }
            break;

        case SIG_SHOWRESULTS_AFTER_CLOSE:
            if ($choice->publish == SIG_PUBLISH_ANONYMOUS) {
                $publishinfo = get_string('publishinfoanonclose', 'choice');
            } else {
                $publishinfo = get_string('publishinfofullclose', 'choice');
            }
            break;

        default:
            // No need to inform the user in the case of SIG_SHOWRESULTS_ALWAYS since it's already obvious that the results are
            // being published.
            break;
    }

    // Show info if necessary.
    if (!empty($publishinfo)) {
        //echo $OUTPUT->notification($publishinfo, 'info');
    }

    //html
    $donwloadHref = (new moodle_url($PAGE->url, array(
        'view_pdf' => 1
    )))->out();
    $linkDownloadDoc = '<a href="'.$donwloadHref.'" id="show_pdf" target="_blank">';
        $linkDownloadDoc .= get_string('view_PDF', 'mod_signactivityserver').'<i class="fa fa-file-pdf-o" style="margin-left:10px;" aria-hidden="true"></i>';
    $linkDownloadDoc .= '</a>';

    echo $OUTPUT->box($linkDownloadDoc, 'm-b-1');

    // They haven't made their choice yet or updates allowed and choice is open.
    $options = signactivityserver_prepare_options($choice, $USER, $cm, $allresponses);
    $renderer = $PAGE->get_renderer('mod_signactivityserver');
    echo $renderer->display_options($options, $cm->id, $choice->display, $choice->allowmultiple);
    $choiceformshown = true;
} else {
    $choiceformshown = false;
}

if (!$choiceformshown) {
    $sitecontext = context_system::instance();

    if (isguestuser()) {
        // Guest account
        echo $OUTPUT->confirm(get_string('noguestchoose', 'choice').'<br /><br />'.get_string('liketologin'),
                     get_login_url(), new moodle_url('/course/view.php', array('id'=>$course->id)));
    } else if (!is_enrolled($context)) {
        // Only people enrolled can make a choice
        $SESSION->wantsurl = qualified_me();
        $SESSION->enrolcancel = get_local_referer(false);

        $coursecontext = context_course::instance($course->id);
        $courseshortname = format_string($course->shortname, true, array('context' => $coursecontext));

        echo $OUTPUT->box_start('generalbox', 'notice');
        echo '<p align="center">'. get_string('notenrolledchoose', 'choice') .'</p>';
        echo $OUTPUT->container_start('continuebutton');
        echo $OUTPUT->single_button(new moodle_url('/enrol/index.php?', array('id'=>$course->id)), get_string('enrolme', 'core_enrol', $courseshortname));
        echo $OUTPUT->container_end();
        echo $OUTPUT->box_end();

    }
}

// print the results at the bottom of the screen
if (signactivityserver_can_view_results($choice, $current, $choiceopen)) {
    $results = prepare_signactivityserver_show_results($choice, $course, $cm, $allresponses);
    $renderer = $PAGE->get_renderer('mod_signactivityserver');
    $resultstable = $renderer->display_result($results);
    echo $OUTPUT->box($resultstable);

} else if (!$choiceformshown) {
    //echo $OUTPUT->box(get_string('noresultsviewable', 'choice'));
}

echo $OUTPUT->footer();
