<?php
//call moodle
require_once(dirname(__FILE__) .'/../../config.php');

//login to moodle required
require_login();

function refresh() {
    $url = new moodle_url('/mod/signactivityserver/user_settings.php');
    redirect($url);
}

$PAGE->set_context(context_system::instance());

global $USER;

//check permisions
if(!has_capability('mod/signactivityserver:view', context_system::instance())) exit;

//configure page title
$PAGE->set_title(get_string('pluginname', 'mod_signactivityserver'));
$PAGE->set_heading(get_string('user_settings', 'mod_signactivityserver'));

//configure page layout
$PAGE->set_pagelayout('standard');
$PAGE->set_cacheable(false);
$PAGE->set_url($_SERVER['REQUEST_URI']);

//navbar
$PAGE->navbar->add(get_string('pluginname', 'mod_signactivityserver'));
$PAGE->navbar->add(get_string('user_settings', 'mod_signactivityserver'), new moodle_url($_SERVER['REQUEST_URI']));

check_delete_signature();
check_settings();

//moodle header
echo $OUTPUT->header();

$params = get_data();
if ($params->signature) {
    echo '<a class="btn btn-primary" id="delete" role="button" style="display:inline-block;" href="?delete_signature='.$USER->id.'">' . get_string('delete', 'mod_signactivityserver').'</a> <span id="delete_desc" style="display:inline-block;">' . get_string('delete_desc', 'mod_signactivityserver'). '</span>';
    echo '<a class="btn btn-primary" id="insert" role="button" style="display:none;" tabindex onclick="window.mod_signactivityserver_add_event()">' . get_string('insert', 'mod_signactivityserver').'</a> <span id="insert_desc" style="display:none;">' . get_string('insert_desc', 'mod_signactivityserver'). '</span>';
    echo '<span id="insert_alt" style="display:none;">' . get_string('insert_alt', 'mod_signactivityserver'). '</span>';
} else if ((is_siteadmin() && $params->force) || ($params->allowsave && !$params->force && $params->adminsave)) {
    echo '<a class="btn btn-primary" id="delete" role="button" style="display:none;" href="?delete_signature='.$USER->id.'">' . get_string('delete', 'mod_signactivityserver').'</a> <span id="delete_desc" style="display:none;">' . get_string('delete_desc', 'mod_signactivityserver'). '</span>';
    echo '<a class="btn btn-primary" id="insert" role="button" style="display:inline-block;" tabindex onclick="window.mod_signactivityserver_add_event()">' . get_string('insert', 'mod_signactivityserver').'</a> <span id="insert_desc" style="display:inline-block;">' . get_string('insert_desc', 'mod_signactivityserver'). '</span>';
    echo '<span id="insert_alt" style="display:none;">' . get_string('insert_alt', 'mod_signactivityserver'). '</span>';
} else if (!$params->adminsave) {
    echo '<a class="btn btn-primary" id="delete" role="button" style="display:none;" href="?delete_signature='.$USER->id.'">' . get_string('delete', 'mod_signactivityserver').'</a> <span id="delete_desc" style="display:none;">' . get_string('delete_desc', 'mod_signactivityserver'). '</span>';
    echo '<a class="btn btn-primary" id="insert" role="button" style="display:none;" tabindex onclick="window.mod_signactivityserver_add_event()">' . get_string('insert', 'mod_signactivityserver').'</a> <span id="insert_desc" style="display:none;">' . get_string('insert_desc', 'mod_signactivityserver'). '</span>';
    echo '<span id="insert_alt" style="display:inline-block;">' . get_string('insert_alt', 'mod_signactivityserver'). '</span>';
} else { 
    echo '<a class="btn btn-primary" id="delete" role="button" style="display:none;" href="?delete_signature='.$USER->id.'">' . get_string('delete', 'mod_signactivityserver').'</a> <span id="delete_desc" style="display:none;">' . get_string('delete_desc', 'mod_signactivityserver'). '</span>';
    echo '<a class="btn btn-primary" id="insert" role="button" style="display:none;" tabindex onclick="window.mod_signactivityserver_add_event()">' . get_string('insert', 'mod_signactivityserver').'</a> <span id="insert_desc" style="display:none;">' . get_string('insert_desc', 'mod_signactivityserver'). '</span>';
    echo '<span id="insert_alt" style="display:none;">' . get_string('insert_alt', 'mod_signactivityserver'). '</span>';
}

if ($params->adminsave) {
    if ($params->signature || ($params->adminsave && $params->allowsave)) echo '<br><br>';
    echo '<form action="user_settings.php"><input type="hidden" name="checkbox" value="true"><input type="checkbox" name="save" '.update_checkbox().'> <span>' . get_string('user_save_desc', 'mod_signactivityserver'). '</span><br><br><input type="submit" value="' . get_string('user_save_button', 'mod_signactivityserver').'"></form> ';
}

//moodle footer
echo $OUTPUT->footer();