<?php

require_once(dirname(__FILE__) .'/../../config.php');
require_once("locallib.php");
require_once("lib.php");
require_once("config.php");

$id = required_param('id', PARAM_INT);
$userid = required_param('userid', PARAM_INT);
$answer = optional_param('answer', -1, PARAM_INT);

if (! $cm = get_coursemodule_from_id('signactivityserver', $id)) {
    print_error('invalidcoursemodule');
}

if (! $course = $DB->get_record("course", array("id" => $cm->course))) {
    print_error('coursemisconf');
}

if (!$choice = signactivityserver_get_choice($cm->instance)) {
    print_error('invalidcoursemodule');
}

require_course_login($course, false, $cm);

$params = array(
    'choiceid' => $cm->instance,
    'userid' => $userid,
    'optionid' => $answer,
    'timemodified' => time(),
    'pdf_signed' => ''
);

if ($answer == -1) save_and_redirect($params, $cm);
else {
    $option = $DB->get_record('sig_choice_options', array('id' => $answer));
    if ($option->signable) {

        $content = '';
        $context = context_module::instance($cm->id);
        $file = $DB->get_record_select('files', 'contextid = '.$context->id.' AND filearea = "document_to_sign" AND filesize <> 0', null, 'userid, pathnamehash');

        if ($file) {
            $fs = get_file_storage();
            $file = $fs->get_file_by_hash($file->pathnamehash);
            $content = $file->get_content();
        }

        $url = new moodle_url('/mod/signactivityserver/sign_pdf.php', array('id'=>$id));
        $PAGE->set_url($url);

        $PAGE->set_title($choice->name);
        $PAGE->set_heading($course->fullname);

        echo $OUTPUT->header();
        echo $OUTPUT->heading(format_string($choice->name), 2, null);

        echo $OUTPUT->box_start('generalbox', 'notice');
        echo $OUTPUT->container_start('continuebutton');

        $key = random_string(10) . '_' . $USER->id;
        save_key($key);

        $api_key = get_config('signactivityserver', 'api_key');

        echo get_signature_iframe('sign_embed', $cm->instance, $content, $api_key, ['userid' => $userid, "optionid" => $answer, "key" => $key]);

        echo $OUTPUT->container_end();
        echo $OUTPUT->box_end();

        echo $OUTPUT->footer();

    } else save_and_redirect($params, $cm);
}
function save_and_redirect($params, $cm) {
    global $DB, $CFG;

    $DB->insert_record('sig_choice_answers', $params);

    $url = $CFG->wwwroot . '/mod/signactivityserver/view.php?id='.$cm->id;
    header("Location: " . $url);
}