<?php

require_once(dirname(__FILE__) .'/../../config.php');
require_once("locallib.php");
require_once("lib.php");


$pdf_signed = base64_decode(required_param('signed_pdf', PARAM_TEXT), true);
$ctx = json_decode(required_param('ctx', PARAM_RAW));

if (! $cm = get_coursemodule_from_instance('signactivityserver', $ctx->id)) {
    print_error('invalidcoursemodule');
}

if (! $course = $DB->get_record("course", array("id" => $cm->course))) {
    print_error('coursemisconf');
}

if (!$choice = signactivityserver_get_choice($cm->instance)) {
    print_error('invalidcoursemodule');
}

if ($ctx->key) {
    $context = context_module::instance($cm->id);

    $user_id = $DB->get_record('signactivityserver_key', array('user_key' => $ctx->key));
    if ($user_id) {
        $user_id = $user_id->user_id;
        $USER = $DB->get_record('user', array('id' => $user_id));

        $current = signactivityserver_get_my_response($choice);
        $answered = empty($current) ? false : signactivityserver_check_answered($choice, reset($current)->optionid);

        if (isloggedin() && 
            (!$answered || $choice->allowupdate) && 
            is_enrolled($context, NULL, 'mod/signactivityserver:choose')) {

            $file = sig_store_signed_file('name', $pdf_signed, $USER->id, $context->id, 'document_signed');
            $record = $DB->get_record('sig_choice_answers', array('choiceid' => $ctx->id, 'userid' => $ctx->userid));

            if ($record) {
                $record->pathnamehash = $file->get_pathnamehash();
                $record->optionid = $ctx->optionid;
                $record->timemodified = time();
                $DB->update_record('sig_choice_answers', $record);
            } else {
                $record = new stdClass();
                $record->choiceid = $ctx->id;
                $record->userid = $ctx->userid;
                $record->pathnamehash = $file->get_pathnamehash();
                $record->optionid = $ctx->optionid;
                $record->timemodified = time();
                $DB->insert_record('sig_choice_answers', $record);
            }

            $url = $CFG->wwwroot . '/pluginfile.php/' . $file->get_contextid(). '/' . $file->get_component() . '/' . $file->get_filearea() . '/' . $file->get_itemid() . '/' . $file->get_filename();
            
            ?>
            <script> 
                var url = <?php echo json_encode($url); ?>;
                window.location.href = url;
            </script>
            <?php

            die();

        }
    }
}