<?php

require_once(dirname(__FILE__) .'/../../config.php');
require_once("locallib.php");

$pdf = required_param('report_engine_value', PARAM_TEXT);
$ctx = json_decode(required_param('ctx', PARAM_RAW));

if ($ctx->key) {
    $cm = get_coursemodule_from_instance('signactivityserver', $ctx->id);
    $context = context_module::instance($cm->id);

    $user_id = $DB->get_record('signactivityserver_key', array('user_key' => $ctx->key));
    if ($user_id) {
        $user_id = $user_id->user_id;
        $USER = $DB->get_record('user', array('id' => $user_id));

        if (has_capability('mod/signactivityserver:uploaddocument', $context)) {
            $file = sig_store_signed_file('name', $pdf, $USER->id, $context->id, 'document_to_sign');
            
            if(!$ctx->embed) {
                $url = $CFG->wwwroot . '/mod/signactivityserver/view.php?id='.$cm->id;
                header("Location: " . $url);
            }
            else {
                echo get_signature_iframe('edit', $ctx->id, $pdf);
            }
            die();
        }
    }
} else {
    echo "Api key not valid.";
}