<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'signactivityserver', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   mod_signactivityserver
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['pluginname'] = 'Sign plugin';
$string['modulename'] = 'Sign activity';
$string['modulename_help'] = 'The sign activity module enables a teacher to have documents signed by the students.

Then, the signed documents can be viewed and downloaded by the teacher or by the student who signed them.

The signature popup is configurable with the following features:

* Allow saving signatures
* Force the student to sign
* Show the signature popup after the first login';
$string['modulenameplural'] = 'Sign activity';
$string['view_signature'] = 'View signature';

// User settings
$string['user_settings'] = 'Sign activity user settings';
$string['delete'] = 'Delete Signature';
$string['delete_desc'] = 'Click to delete your current saved signature';
$string['user_save_desc'] = 'Save your signature next time you sign';
$string['user_save_button'] = 'Save settings';
$string['insert'] = 'Create Signature';
$string['insert_desc'] = 'Click to store a new signature';
$string['insert_alt'] = 'Currently your admin does not allow you to change the user configuration';

// Admin settings
$string['settings'] = 'Sign Activity Settings';
$string['pluginadministration'] = 'Sign administration';
$string['api_key'] = 'API key';
$string['api_key_desc'] = 'Your private api key of the signing server.';

// Popup 
$string['sign_popup_header'] = 'Digitize signature';
$string['sign_popup_clear'] = 'Clear';
$string['sign_popup_ok'] = 'Done';
$string['save_warning'] = 'Your signature will be saved';
$string['nosave_warning'] = 'Your signature will not be saved';

// Others
$string['signable'] = 'Option requires to sign';
$string['downloadall'] = 'Download all documents';
$string['view_link'] = 'View document';
$string['view_PDF'] = 'View PDF';
$string['required_signature'] = 'Requires signature';
$string['nopdf'] = 'No PDF has been selected';
$string['upload_pdf'] = 'Upload PDF';
$string['edit_pdf'] = 'Edit PDF';
$string['not_available'] = 'This activity is not available yet';

// Coordinates page
$string['select_coordinates_header'] = 'Select coordinates page';
$string['select_coordinates_tooltip'] = 'You can copy and paste the text inside the box into the coordinates field in the create activity form.';
$string['select_coordinates_clear_page'] = 'Clear current page';
$string['select_coordinates_no_pdf'] = 'You have no pdf to view';

// Capabilities
$string['mod/signactivityserver:deleteresponses'] = 'Delete responses';
$string['mod/signactivityserver:uploaddocument'] = 'Upload document';
$string['mod/signactivityserver:downloadresponses'] = 'Download responses';
$string['mod/signactivityserver:readresponses'] = 'View responses';
$string['mod/signactivityserver:addinstance'] = 'Add instance';
$string['mod/signactivityserver:choose'] = 'Choose response';
$string['mod/signactivityserver:view'] = 'View instance';