<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    mod_signactivityserver
 * @subpackage backup-moodle2
 * @copyright  2010 onwards Eloy Lafuente (stronk7) {@link http://stronk7.com}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


defined('MOODLE_INTERNAL') || die();


/**
 * Define all the backup steps that will be used by the backup_quiz_activity_task
 *
 * @copyright  2010 onwards Eloy Lafuente (stronk7) {@link http://stronk7.com}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class backup_signactivityserver_activity_structure_step extends backup_activity_structure_step {

    protected function define_structure() {

        // To know if we are including userinfo.
        $userinfo = $this->get_setting_value('userinfo');

        $signactivityserver = new backup_nested_element('signactivityserver', array('id'), array(
            'course', 'name', 'intro', 'introformat', 'publish', 'showresults', 'display',
            'allowupdate', 'allowmultiple', 'showunanswered', 'includeinactive', 'limitanswers',
            'timeopen', 'timeclose', 'showpreview', 'timemodified', 'completionsubmit'));

        $options = new backup_nested_element('options');

        $option = new backup_nested_element('option', array('id'), array(
            'text', 'maxanswers', 'timemodified', 'signable'));

        $signactivityserver->add_child($options);
        $options->add_child($option);

        $signactivityserver->set_source_table('signactivityserver', array('id' => backup::VAR_ACTIVITYID));

        $option->set_source_sql('
            SELECT *
            FROM {sig_choice_options}
            WHERE choiceid = ?',
            array(backup::VAR_PARENTID));

        $signactivityserver->annotate_files('mod_signactivityserver', 'document_to_sign', null); // This file area does not have an itemid.

        // Return the root element (signactivityserver), wrapped into standard activity structure.
        return $this->prepare_activity_structure($signactivityserver);
    }
}
