# Documentación Plugin Firmas

El objetivo de este plugin es permitir a un profesor subir PDFs a firmar por sus alumnos. Una vez firmados, el profesor y el alumno que firmó los PDFs los pueden descargar.

## Administrador

El administrador es el encargado de cambiar la configuración del plugin. Para ello debe ir a Administración del sitio->Extensiones->Vista general de extensiones->Plugin de Firmas->Configuración. Hay tres opciones:

* Mostrar el recuadro para firmar después del primer login.
* Forzar a firmar: esto obliga al usuario a firmar y no deja realizar otras acciones hasta que no se haya firmado. Esto también fuerza que se guarden las firmas en la base de datos.
* Permitir guardar la firma: Esto permite al usuario elegir si quiere que se guarde su firma en base de datos (en caso de que la opción de Forzar a firmar esté marcada esta opción no se podrá modificar y el usuario no podrá elegir).

## Profesor

Para usar este plugin, el profesor debe crear una actividad en un curso, llamada "Actividad de Firmas". Al crear la actividad, hay que subir un PDF sin encriptar y especificar las coordenadas de donde deben ir la/s firma/s. Las coordenadas deben tener el siguiente formato:
    
PÁGINA:COORDENADA INICIAL X,COORDENADA INICIAL Y,COORDENADA FINAL X,COORDENADA FINAL Y

Hay que preparar el PDF antes de subirlo: abrir el documento con un lector de PDF, pulsar la opción de _Imprimir_, y guardarlo. Con esto el PDF queda con un formato PDF básico que es el único que se puede subir.

### Página de selección de coordenadas

Al hacer clic en la flecha lateral se puede abrir una pestaña de ayuda donde puedes elegir visualmente dónde se mostrará la firma. Puedes hacerlo directamente sobre el pdf haciendo 2 clics (esquina superior izquierda y esquina inferior derecha de la zona que queramos marcar).
Una vez seleccionado, copiar el texto del recuadro lateral de la página e introducir el texto copiado dentro de la casilla _Coordenadas del documento_.

La coordenada (0,0) corresponde a la esquina superior izquierda. El eje X es positivo hacia la derecha y el eje Y es positivo hacia abajo. Todas las medidas van el píxeles. En caso de que más de una página deba ser firmada, las coordenadas deben separarse por ";". Las coordenadas finales son opcionales y si no se especifican se aplicará una anchura por defecto. Algunos ejemplos:

* 1:200,300
* 2:150,400,250,500;4:100,300

### Opciones

En el apartado Opciones, hay que introducir las posibles respuestas del usuario (Sí, No, Acepto, etc.) y marcar las que requieran de firma.

Una vez los alumnos hayan firmado, el profesor puede ir a la actividad y ver sus respuestas. Allí puede descargar los PDFs firmados individualmente o todos juntos en un archivo zip.

## Estudiante

Como estudiante puedes ver las opciones del plugin en Preferencias->Cuenta de usuario->Opciones de usuario de la actividad de firmas. En este apartado siempre se tendrá la opción de borrar la firma en caso de que se haya guardado en base de datos. En caso contrario, si el administrador lo permite, se podrá crear una nueva firma y decidir si se quiere guardar en base de datos.

El beneficio de guardar la firma en base de datos es que no se pedirá cada vez que se realice una actividad donde sea necesario firmar. Esta firma se puede editar siempre que se quiera antes de firmar.

