<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    mod_signactivityserver
 * @subpackage backup-moodle2
 * @copyright  2010 onwards Eloy Lafuente (stronk7) {@link http://stronk7.com}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


defined('MOODLE_INTERNAL') || die();


/**
 * Structure step to restore one quiz activity
 *
 * @copyright  2010 onwards Eloy Lafuente (stronk7) {@link http://stronk7.com}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class restore_signactivityserver_activity_structure_step extends restore_activity_structure_step {

    /**
     * @var bool tracks whether the quiz contains at least one section. Before
     * Moodle 2.9 quiz sections did not exist, so if the file being restored
     * did not contain any, we need to create one in {@link after_execute()}.
     */
    protected $sectioncreated = false;

    /**
     * @var bool when restoring old quizzes (2.8 or before) this records the
     * shufflequestionsoption quiz option which has moved to the quiz_sections table.
     */
    protected $legacyshufflequestionsoption = false;

    protected function define_structure() {

        $paths = array();
        $userinfo = $this->get_setting_value('userinfo');
 
        $paths[] = new restore_path_element('signactivityserver', '/activity/signactivityserver');
        $paths[] = new restore_path_element('sig_choice_option', '/activity/signactivityserver/options/option');
 
        // Return the paths wrapped into standard activity structure
        return $this->prepare_activity_structure($paths);
    }

    protected function process_signactivityserver($data) {
        global $CFG, $DB;
        
        $data = (object)$data;
        $oldid = $data->id;
        $data->course = $this->get_courseid();

        // Insert the quiz record.
        $newitemid = $DB->insert_record('signactivityserver', $data);
        // Immediately after inserting "activity" record, call this.
        $this->apply_activity_instance($newitemid);
    }

 
    protected function process_sig_choice_option($data) {
        global $DB;
 
        $data = (object)$data;
        $oldid = $data->id;
 
        $data->choiceid = $this->get_new_parentid('signactivityserver');
 
        $newitemid = $DB->insert_record('sig_choice_options', $data);
        $this->set_mapping('sig_choice_option', $oldid, $newitemid);
    }

    protected function after_execute() {
        // Add choice related files, no need to match by itemname (just internally handled context)
        $this->add_related_files('mod_signactivityserver', 'document_to_sign', null);
    }

}
